

/**********************************************************************************************
 *                                                                                            *
 * Ex.3 :  Application Read BCD Touch key Out data to LCD (ET-BASE AVR EASY MEGA168 Board)    *
 *        (Format:Press key Shift + Key Other)                                                *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU      : ATMEGA168(Arduino)                                                       *
 *                 : X-TAL : 16 MHz                                                           *
 *                                                                                            *
 * Compiler Editor : Arduino 1.0.4                                                            *
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                     *
 * Last Update     : 12/September/2014                                                        *
 *                                                                                            *
 * Port Interface  :  --- MCU-AT MEGA168(Arduino)---         --- Key Touch PAD 4x4 ---        *  
 *                                                                                            *
 *                                                                                            *
 *      BCD Port  :  D8(Input)          Connect                 BCD Colum 1                   * 
 *                   D9(Input)          Connect                 BCD Colum 2                   *
 *                   D10(Input)         Connect                 BCD Colum 4                   *
 *                   D11(Input)         Connect                 BCD Colum 8                   *
 *                   D12(Input)         Connect                 T#/R Ststus 1Key              *
 *                   D13(Input)         Not Use                 SHIF# Statu 2Key              *
 *                                                                                            *
 *       LCD     :   Connect 4bit data ;LCD 16x2) by                                          *
 *                   D1(output)         Connect                 RS                            *
 *                   D2(output)         Connect                 R/W                           *
 *                   D3(output)         connect                 E                             *
 *                   D4-D7(output)      connect                 Data 4 bit high               *
 *                                                                                            *
 *                                                                                            *
 *       5V                                                                                   *
 *      --+--                                                                                 *
 *        |                                                                                   *
 *        +-----------------+                                                                 *
 *        |                 |                                                                 *
 *       ---                |                                                                 *
 *       |\|                |                                                                 *
 *    VR |/|<---------------|--+                                                              *
 *   10K ---                |  |  D1  D2  D3            D4    D5     D6      D7               *
 *        |                 |  |   ^   ^  ^              ^     ^      ^      ^                *
 *        |                 |  |   |   |  |              |     |      |      |                *
 *        +--------------+--|--|---|---|--|--+--+--+--+  |     |      |      |                *
 *      __|__            |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *       ---             |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *        -             1| 2| 3|  4|  5| 6| 7| 8| 9|10|11|   12|    13|    14|                *
 *                     __|__|__|___|___|__|__|__|__|__|__|___ _|___ __|___ __|_               *
 *                    |  G Vcc Vo RS  R/W E D0 D1 D2 D3 D4    D5      D6    D7 |              *
 *                    |      _____________________________________________     |              *
 *                    |     |                                             |    |              *
 *                    |     |                 Module                      |    |              *
 *                    |     |           LCD 2x16 Charecter                |    |              *  
 *                    |     |_____________________________________________|    |              *
 *                    |                                                        |              *
 *                    |________________________________________________________|              *
 *                                                                                            *                                                                                           *
 *                                                                                            *
 **********************************************************************************************/

#include <LiquidCrystal.h>    // include the library code:



//----------- Defind BCD Port D8..D13 ---------------- 

#define BCD1           8      //D8
#define BCD2           9      //D9
#define BCD4          10      //D10   
#define BCD8          11      //D11
#define TR            12      //D12
#define Shif          13      //D13



//----------- Defind LCD Port D1..D7 ---------------- 

#define RS           1      //D1
#define RW           2      //D2
#define EN           3      //D3   
#define DB4          4      //D4
#define DB5          5      //D5
#define DB6          6      //D6
#define DB7          7      //D7



LiquidCrystal lcd(RS,RW,EN,DB4,DB5,DB6,DB7);  // initialize the library with the numbers of the interface pins


//****************************** Sub Program ******************************


//---------------------- Check Touch /Release for 2Key -------------------

char Check_SHIF(void)   
{
   char sh   ;
        
   sh = digitalRead(Shif)         ;    //Read Status Key(D13) (Statust Press or Release : 2Key)
   
   if(sh != 1)                         //Check Statue Key
      return (0)                  ;    //Touch 2Key Return 0 (D13=0)
   else
      return (1)                  ;    //Release Key All Return 1 (D13=1)


}

//---------------------- Check Touch /Release Key -------------------

char Check_TR(void)    
 {
   char tr   ;
        
    tr = digitalRead(TR)         ;   //Read Status Key
   
    if(tr != 1)                      //Check Statue Key
      return (0)                ;    //Touch Key Return 0 (D12=0)
    else
       return (1)               ;    //Release Key Return 1 (D12=1)
 }


//---------- Read BCD Key Code -----------------

 int RD_KeyCode(void) 
  {
    int KeyCode=0                 ;
   
     KeyCode  = digitalRead(BCD8)           ;   //Read BCD(8) Code bit D11   
     KeyCode  = KeyCode << 1                ;
     KeyCode |= digitalRead(BCD4)           ;   //Read BCD(4) Code bit D10 
     KeyCode  = KeyCode << 1                ;
     KeyCode |= digitalRead(BCD2)           ;   //Read BCD(2) Code bit D9   
     KeyCode  = KeyCode << 1                ;
     KeyCode |= digitalRead(BCD1)           ;   //Read BCD(1) Code bit D8   
     KeyCode &= 0x0F                        ;        
    return (KeyCode)                        ;
  }



/*##########################################################################
  ##                                                                      ##
  ##                               SETUP                                  ##
  ##                                                                      ##
  ##########################################################################*/



void setup() 
{ 
 //------------Initial Port D8..D13 =Input for Read Key Code --------------- 
  
    pinMode(BCD1,INPUT_PULLUP)           ; //Set Status pin D8  = Input Pull-Up 
    pinMode(BCD2,INPUT_PULLUP)           ; //Set Status pin D9  = Input Pull-Up  
    pinMode(BCD4,INPUT_PULLUP)           ; //Set Status pin D10 = Input Pull-Up  
    pinMode(BCD8,INPUT_PULLUP)           ; //Set Status pin D11 = Input Pull-Up  
    pinMode(TR,INPUT_PULLUP)             ; //Set Status pin D12 = Input Pull-Up  
    pinMode(Shif,INPUT_PULLUP)           ; //Set Status pin D13 = Input Pull-Up 
    
    lcd.begin(16,2)                      ; //Set up the LCD's number of columns and rows
    
}



/*#######################################################################
 ##                                                                    ##
 ##                        MAIN PROGRAM                                ##
 ##                                                                    ##
 #######################################################################*/
 

void loop() 
{ 
   unsigned int key ;
 
  lcd.setCursor(0,0)             ; // Set the cursor to column 0, line 0  
  lcd.print("ET-TOUCH PAD 4x4")  ; // Print a message to the LCD
  
  lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
  lcd.print(" Not!Touch Key! ")  ; // Print a message to the LCD
  
  
  while(1)
  {
   if(!Check_TR())                                //Step1: Check  Touch key (Check_TR()=0:Touch,1:release) 
      {
        key  = RD_KeyCode()                    ;  //Step2: Read Key Code

        if( key == 0x0F)                          //Step3: Check Touch Key Shift(Touch the 1st Key) is Touch 2 Key
          {
            do
             {
               if(!Check_SHIF())                  //Step3.1 : Check Touch Key Other(Touch the 2nd Key) by 0:touch,1: not touch
                 {                   
                   key = RD_KeyCode()          ;  //Step 3.2  Read Key Code for Key Shif+Key Other

                   //---------- Step3.3:Program Respond Touch 2key for user(SHIF+Key) ------------
                   switch(key)
                    {
                      case 0x01 :   //Shif+Key#1
                                  lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                  lcd.print("Touch Key:SH+'1'")  ; // Print a message to the LCD
                              
                                  break;

                      case 0x02 :   //Shif+Key#2
                                  lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                  lcd.print("Touch Key:SH+'2'")  ; // Print a message to the LCD
                              
                                  break;

                      case 0x03 :   //Shif+Key#3
                                  lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                  lcd.print("Touch Key:SH+'3'")  ; // Print a message to the LCD
                              
                                  break;


                     case 0x04 :   //Shif+Key#4
                                 lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                 lcd.print("Touch Key:SH+'4'")  ; // Print a message to the LCD
                              
                                 break;

                     case 0x05 :   //Shif+Key#5
                                 lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                 lcd.print("Touch Key:SH+'5'")  ; // Print a message to the LCD                        
                              
                                 break;


                     case 0x06 :   //Shif+Key#6
                                 lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                 lcd.print("Touch Key:SH+'6'")  ; // Print a message to the LCD
                              
                                 break;


                    case 0x07 :   //Shif+Key#7
                                lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                lcd.print("Touch Key:SH+'7'")  ; // Print a message to the LCD
                           
                                break;


                    case 0x08 :   //Shif+Key#8
                                lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                lcd.print("Touch Key:SH+'8'")  ; // Print a message to the LCD
                                                            
                                break;


                    case 0x09 :   //Shif+Key#9
                                lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                lcd.print("Touch Key:SH+'9'")  ; // Print a message to the LCD
                            
                                break;

                    case 0x00 :   //Shif+Key#0
                                lcd.setCursor(0,1)             ; // Set the cursor to column 0, line 1  
                                lcd.print("Touch Key:SH+'0'")  ; // Print a message to the LCD
                              
                                break;

                    }//switch
                     
                   while(!Check_SHIF()){;}                    ;  //Wait Release 2Key (=1 exit loop)
              
                   lcd.setCursor(0,1)                         ;  //Set the cursor to column 0, line 1  
                   lcd.print(" Not!Touch Key! ")              ;  //Print a message to the LCD
                
                 } //if Check Shif
                                                
             }while(!Check_TR())                              ;  //Loop wait Touch the 2nd Key , Exit loop When release Key Shif or 2Key      

          }   //if key == 0x0F
        else                                                     //Step4: Check Touch Key Other don't key Shift is Touch 1 Key
          { 
            //---------- Step4.1:Program Respond Touch 1 key for user ------------     
            switch(key)
             {
               case 0x01 :   //Key#1
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '1'")       ; //Print a message to the LCD
                      
                          break;

               case 0x02 :   //Key#2
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '2'")       ; //Print a message to the LCD
                      
                          break;


               case 0x03 :   //Key#3
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '3'")       ; //Print a message to the LCD
                    
                          break;

              case 0x04 :   //Key#4
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '4'")       ; //Print a message to the LCD
                      
                          break;


              case 0x05 :  //Key#5 
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '5'")       ; //Print a message to the LCD
                       
                          break;


              case 0x06 :   //Key#6
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '6'")       ; //Print a message to the LCD                        
                     
                          break;

              case 0x07 :   //Key#7
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '7'")       ; //Print a message to the LCD
                      
                          break;

              case 0x08 :   //Key#8
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '8'")       ; //Print a message to the LCD                          
                       
                          break;

              case 0x09 :  //Key#9
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '9'")       ; //Print a message to the LCD
                      
                          break;

              case 0x00 :  //Key#0
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = '0'")       ; //Print a message to the LCD
                     
                          break;

              case 0x0A :  //Key#A(Clear)
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = 'A'")       ; //Print a message to the LCD
                      
                          break;

              case 0x0B :  //Key#B
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = 'B'")       ; //Print a message to the LCD
                      
                          break;


              case 0x0C :   //Key#C
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = 'C'")       ; //Print a message to the LCD
                      
                          break;


              case 0x0D :  //Key#D
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = 'D'")       ; //Print a message to the LCD
                      
                          break;

              case 0x0E :   //Key#E
                          lcd.setCursor(0,1)                  ; //Set the cursor to column 0, line 1  
                          lcd.print("Touch Key  = 'E'")       ; //Print a message to the LCD
                     
                          break;

           }//Switch
         
            while(!Check_TR()){;}                            ;   //Wait Release Key (=1 exit loop)    
       
           lcd.setCursor(0,1)                                ;  //Set the cursor to column 0, line 1  
           lcd.print(" Not!Touch Key! ")                     ;  //Print a message to the LCD
       } //else
     } //if Check_TR
   } //while
}  
   
   
   
